#pragma once

#include "gmplugin.h"

struct GameChat_t
{
	int PlayerID;
	int Type;
	StringClass Message;
};

class ChatCommand 
{
public:
	int Use; // Can the command be used from IRC, in-game or both?
	DynamicVectorClass<const char*> Triggers; // Aliases that also trigger the command
	StringClass Access; // moderator access required for use of the command
	StringClass Name; // The name of the command
	StringClass HelpInfo; // Text to show for help
	bool Hide; // Whether to display in-game that a player used this command

	void Startup(const char *_Name, int _Use);
	virtual void Activate(int ID, int Type, Tokenizer Msg);
	virtual void Activate_IRC(StringClass Nick, StringClass Channel, Tokenizer Msg);
};

class Commands
{
public:
	static void Load();
	static void Unload();
	static DWORD WINAPI Game_Chat(LPVOID params);

	static HashTemplateClass<StringClass, ChatCommand *> CommandTable;
};

class Help : public ChatCommand
{
public:
//	void Activate(int ID, int Type, Tokenizer Msg);
//	void Activate_IRC(StringClass Nick, StringClass Channel, Tokenizer Msg);
};

class Auth : public ChatCommand
{
public:
	void Activate_IRC(StringClass Nick, StringClass Channel, Tokenizer Msg);
};

class GameInfo : public ChatCommand
{
public:
	void Activate_IRC(StringClass Nick, StringClass Channel, Tokenizer Msg);
};

class ListPlayers : public ChatCommand
{
public:
	void Activate_IRC(StringClass Nick, StringClass Channel, Tokenizer Msg);
};

class Buildings : public ChatCommand
{
public:
	void Activate_IRC(StringClass Nick, StringClass Channel, Tokenizer Msg);
};

class Rotation : public ChatCommand
{
public:
	void Activate_IRC(StringClass Nick, StringClass Channel, Tokenizer Msg);
	void Activate(int ID, int Type, Tokenizer Msg);
};

class NextMap : public ChatCommand
{
public:
	void Activate_IRC(StringClass Nick, StringClass Channel, Tokenizer Msg);
	void Activate(int ID, int Type, Tokenizer Msg);
};

class Ping : public ChatCommand
{
public:
	void Activate_IRC(StringClass Nick, StringClass Channel, Tokenizer Msg);
	void Activate(int ID, int Type, Tokenizer Msg);
};

class Rules : public ChatCommand
{
public:
	void Activate_IRC(StringClass Nick, StringClass Channel, Tokenizer Msg);
	void Activate(int ID, int Type, Tokenizer Msg);
};

class VehicleLimit : public ChatCommand
{
public:
	void Activate_IRC(StringClass Nick, StringClass Channel, Tokenizer Msg);
	void Activate(int ID, int Type, Tokenizer Msg);
};

class MineLimit : public ChatCommand
{
public:
	void Activate_IRC(StringClass Nick, StringClass Channel, Tokenizer Msg);
	void Activate(int ID, int Type, Tokenizer Msg);
};

class Version : public ChatCommand
{
public:
	void Activate_IRC(StringClass Nick, StringClass Channel, Tokenizer Msg);
	void Activate(int ID, int Type, Tokenizer Msg);
};

class ShowMods : public ChatCommand
{
public:
	void Activate_IRC(StringClass Nick, StringClass Channel, Tokenizer Msg);
	void Activate(int ID, int Type, Tokenizer Msg);
};

class FDS : public ChatCommand
{
public:
	void Activate_IRC(StringClass Nick, StringClass Channel, Tokenizer Msg);
	void Activate(int ID, int Type, Tokenizer Msg);
};

class Kill : public ChatCommand
{
public:
	void Activate_IRC(StringClass Nick, StringClass Channel, Tokenizer Msg);
	void Activate(int ID, int Type, Tokenizer Msg);
};

class AdminMessage : public ChatCommand
{
public:
	void Activate_IRC(StringClass Nick, StringClass Channel, Tokenizer Msg);
};

class Message : public ChatCommand
{
public:
	void Activate_IRC(StringClass Nick, StringClass Channel, Tokenizer Msg);
};

class PageCommand : public ChatCommand
{
public:
	void Activate_IRC(StringClass Nick, StringClass Channel, Tokenizer Msg);
};

class PlayerAdminMessage : public ChatCommand
{
public:
	void Activate_IRC(StringClass Nick, StringClass Channel, Tokenizer Msg);
};

class ModeratorList : public ChatCommand
{
public:
	void Activate_IRC(StringClass Nick, StringClass Channel, Tokenizer Msg);
};

class Mute : public ChatCommand
{
public:
	void Activate_IRC(StringClass Nick, StringClass Channel, Tokenizer Msg);
	void Activate(int ID, int Type, Tokenizer Msg);
};

class TeamChange : public ChatCommand
{
public:
	void Activate_IRC(StringClass Nick, StringClass Channel, Tokenizer Msg);
	void Activate(int ID, int Type, Tokenizer Msg);
};

class PlayerScripts : public ChatCommand
{
public:
	void Activate_IRC(StringClass Nick, StringClass Channel, Tokenizer Msg);
};

class ScriptsCommand : public ChatCommand
{
public:
	void Activate_IRC(StringClass Nick, StringClass Channel, Tokenizer Msg);
	void Activate(int ID, int Type, Tokenizer Msg);
};

class ScriptsDownload : public ChatCommand
{
public:
	void Activate(int ID, int Type, Tokenizer Msg);
};

class UpTime : public ChatCommand
{
public:
	void Activate_IRC(StringClass Nick, StringClass Channel, Tokenizer Msg);
	void Activate(int ID, int Type, Tokenizer Msg);
};

class MapTime : public ChatCommand
{
public:
	void Activate_IRC(StringClass Nick, StringClass Channel, Tokenizer Msg);
	void Activate(int ID, int Type, Tokenizer Msg);
};

class Disarm : public ChatCommand
{
public:
	void Activate_IRC(StringClass Nick, StringClass Channel, Tokenizer Msg);
	void Activate(int ID, int Type, Tokenizer Msg);
};

class SetNextMap : public ChatCommand
{
public:
	void Activate_IRC(StringClass Nick, StringClass Channel, Tokenizer Msg);
	void Activate(int ID, int Type, Tokenizer Msg);
};

class Bandwidth : public ChatCommand
{
public:
	void Activate_IRC(StringClass Nick, StringClass Channel, Tokenizer Msg);
};

class LogSearch : public ChatCommand
{
public:
	void Activate_IRC(StringClass Nick, StringClass Channel, Tokenizer Msg);
};